/*
 * Commonly used enumerations in both C++ and C forms
 * (c) 2005 Melissa Data
 *
 * PRELIMINARY VERSION SUBJECT TO CHANGES
 */
#ifndef MDENUMS_H
#define MDENUMS_H

#if defined(__cplusplus) && !defined(MDCFORCE) || defined(__midl)
/*
 * C++ version names have class scope and are not prefixed
 */
#define MDENUM(x)	enum x
#define MDINIT(x,y)	x = y
#define MDNEXT(x)	x
#else
/*
 * C version names have global scope and thus require prefix
 */
#define MDENUM(x)	enum md##x
#define MDINIT(x,y)	md##x = y
#define MDNEXT(x)	md##x
#endif

/*
 * Programming/installation/execution errors
 */
MDENUM(ProgramStatus) {
/* Common errors */
MDINIT(ErrorNone,0),
MDNEXT(ErrorOther),
MDNEXT(ErrorOutOfMemory),
MDNEXT(ErrorRequiredFileNotFound),
MDNEXT(ErrorFoundOldFile),
MDNEXT(ErrorDatabaseExpired),
MDNEXT(ErrorLicenseExpired)
};

/*
 * Backing data access modes
 */
MDENUM(AccessType) {
MDINIT(Local,0),
MDNEXT(Remote)
};

/*
 * Diacritics modes
 */
MDENUM(DiacriticsMode) {
MDINIT(Auto,0),
MDNEXT(On),
MDNEXT(Off)
};

/*
 * Standardization Types
 */
MDENUM(StandardizeMode) {
MDINIT(ShortFormat,0),
MDNEXT(LongFormat),
MDNEXT(AutoFormat)
};

/*
 * SuiteParsing Types
 */
MDENUM(SuiteParseMode) {
MDINIT(ParseSuite,0),
MDNEXT(CombineSuite)
};

/*
 * AliasPreservation Types
 */
MDENUM(AliasPreserveMode) {
MDINIT(ConvertAlias,0),
MDNEXT(PreserveAlias)
};

MDENUM(AutoCompletionMode)
{
MDINIT(AutoCompleteSingleSuite,0),
MDNEXT(AutoCompleteRangedSuite),
MDNEXT(AutoCompletePlaceHolderSuite),
MDNEXT(AutoCompleteNoSuite)
};

MDENUM(ResultCdDescOpt) {
/* Result Code Description */
MDINIT(ResultCodeDescriptionLong, 0),
MDNEXT(ResultCodeDescriptionShort)
};	

MDENUM(MailboxLookupMode){
/* Mailbox lookup modes*/
MDINIT(MailboxNone,0),
MDNEXT(MailboxExpress),
MDNEXT(MailboxPremium)
};
#undef MDENUM
#undef MDINIT
#undef MDNEXT

#endif
